<?php

use yii\helpers\Html;

$this->title = 'Наши курсы';
$this->params['breadcrumbs'][] = $this->title;
?>
<div class="site-courses">
    <h1><?= Html::encode($this->title) ?></h1>
    
    <p class="lead mb-4">
        Выберите подходящий курс для профессионального развития. 
        Все курсы проводятся онлайн с поддержкой опытных преподавателей.
    </p>

    <?php if (empty($courses)): ?>
        <div class="alert alert-warning">
            На данный момент нет доступных курсов.
        </div>
    <?php else: ?>
        <div class="row">
            <?php foreach ($courses as $course): ?>
                <div class="col-md-6 mb-4">
                    <div class="card h-100">
                        <div class="card-body">
                            <h4 class="card-title"><?= Html::encode($course->name) ?></h4>
                            
                            <div class="mb-3">
                                <span class="badge bg-primary me-2">
                                    <?= $course->duration_hours ?> часов
                                </span>
                                <span class="badge bg-success">
                                    <?= Yii::$app->formatter->asCurrency($course->price) ?>
                                </span>
                            </div>
                            
                            <?php if ($course->description): ?>
                                <p class="card-text"><?= Html::encode($course->description) ?></p>
                            <?php endif; ?>
                        </div>
                        
                        <div class="card-footer bg-transparent">
                            <?php if (!Yii::$app->user->isGuest && !Yii::$app->user->identity->isAdmin()): ?>
                                <?= Html::a('Подать заявку', ['/application/create', 'course_id' => $course->id], [
                                    'class' => 'btn btn-success'
                                ]) ?>
                            <?php elseif (Yii::$app->user->isGuest): ?>
                                <div class="alert alert-info mb-0">
                                    <small>
                                        <?= Html::a('Войдите', ['/site/login']) ?> или 
                                        <?= Html::a('зарегистрируйтесь', ['/site/register']) ?> 
                                        чтобы подать заявку
                                    </small>
                                </div>
                            <?php endif; ?>
                        </div>
                    </div>
                </div>
            <?php endforeach; ?>
        </div>
        
        <?php if (!Yii::$app->user->isGuest && !Yii::$app->user->identity->isAdmin()): ?>
            <div class="text-center mt-4">
                <?= Html::a('Подать заявку на другой курс', ['/application/create'], [
                    'class' => 'btn btn-primary btn-lg'
                ]) ?>
            </div>
        <?php endif; ?>
    <?php endif; ?>
</div>