<?php

use yii\helpers\Html;
use yii\widgets\DetailView;

$this->title = 'Заявка #' . $model->id;
$this->params['breadcrumbs'][] = ['label' => 'Мои заявки', 'url' => ['index']];
$this->params['breadcrumbs'][] = $this->title;

$statusText = $model->status == 'new' ? 'Новая' : 
              ($model->status == 'in_progress' ? 'Идет обучение' : 'Обучение завершено');
$statusClass = $model->status == 'new' ? 'badge-primary' : 
               ($model->status == 'in_progress' ? 'badge-warning' : 'badge-success');
?>
<div class="application-view">
    <h1><?= Html::encode($this->title) ?></h1>

    <div class="row">
        <div class="col-md-8">
            <div class="card">
                <div class="card-body">
                    <?= DetailView::widget([
                        'model' => $model,
                        'attributes' => [
                            'id',
                            [
                                'attribute' => 'course_name',
                                'label' => 'Курс',
                                'format' => 'raw',
                                'value' => function($model) {
                                    return Html::tag('strong', Html::encode($model->course_name));
                                }
                            ],
                            [
                                'attribute' => 'desired_start_date',
                                'label' => 'Желаемая дата начала',
                                'format' => ['date', 'long'],
                            ],
                            [
                                'attribute' => 'payment_method',
                                'label' => 'Способ оплаты',
                                'value' => function($model) {
                                    return $model->payment_method == 'cash' ? 'Наличными' : 'Переводом по номеру телефона';
                                }
                            ],
                            [
                                'attribute' => 'status',
                                'label' => 'Статус',
                                'format' => 'raw',
                                'value' => function($model) use ($statusText, $statusClass) {
                                    return Html::tag('span', $statusText, ['class' => 'badge ' . $statusClass]);
                                }
                            ],
                            [
                                'attribute' => 'created_at',
                                'label' => 'Дата подачи',
                                'format' => ['datetime', 'short'],
                            ],
                            [
                                'attribute' => 'updated_at',
                                'label' => 'Последнее обновление',
                                'format' => ['datetime', 'short'],
                            ],
                        ],
                    ]) ?>
                    
                    <?php if ($model->course): ?>
                        <hr>
                        <h5>Информация о курсе:</h5>
                        <ul>
                            <li><strong>Продолжительность:</strong> <?= $model->course->duration_hours ?> часов</li>
                            <li><strong>Стоимость:</strong> <?= Yii::$app->formatter->asCurrency($model->course->price) ?></li>
                            <?php if ($model->course->description): ?>
                                <li><strong>Описание:</strong> <?= Html::encode($model->course->description) ?></li>
                            <?php endif; ?>
                        </ul>
                    <?php endif; ?>
                    
                    <?php if ($model->feedback): ?>
                        <hr>
                        <h5>Ваш отзыв:</h5>
                        <div class="card bg-light">
                            <div class="card-body">
                                <?php if ($model->rating): ?>
                                    <div class="mb-2">
                                        <strong>Оценка:</strong>
                                        <?php for ($i = 1; $i <= 5; $i++): ?>
                                            <?php if ($i <= $model->rating): ?>
                                                <span style="color: #ffc107;">★</span>
                                            <?php else: ?>
                                                <span style="color: #6c757d;">☆</span>
                                            <?php endif; ?>
                                        <?php endfor; ?>
                                        (<?= $model->rating ?>/5)
                                    </div>
                                <?php endif; ?>
                                <p class="mb-0"><?= nl2br(Html::encode($model->feedback)) ?></p>
                            </div>
                        </div>
                    <?php endif; ?>
                </div>
            </div>
        </div>
        
        <div class="col-md-4">
            <div class="card">
                <div class="card-header">
                    <h5 class="card-title mb-0">Действия</h5>
                </div>
                <div class="card-body">
                    <div style="display: flex; flex-direction: column; gap: 10px;">
                        <?= Html::a('Вернуться к списку', ['index'], ['class' => 'btn btn-primary']) ?>
                        
                        <?php if ($model->status == 'completed' && empty($model->feedback)): ?>
                            <?= Html::a('Оставить отзыв', ['feedback', 'id' => $model->id], [
                                'class' => 'btn btn-warning'
                            ]) ?>
                        <?php endif; ?>
                    </div>
                    
                    <hr>
                    
                    <div class="alert alert-info mt-3">
                        <h6>Информация:</h6>
                        <ul class="mb-0 small">
                            <li>Заявка будет рассмотрена администратором в течение 3 рабочих дней</li>
                            <li>После одобрения заявки с вами свяжутся для уточнения деталей</li>
                            <li>Отзыв можно оставить только после завершения обучения</li>
                        </ul>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>