<?php

use yii\helpers\Html;
use yii\widgets\ActiveForm;

$this->title = 'Создание курса';
$this->params['breadcrumbs'][] = ['label' => 'Курсы', 'url' => ['courses']];
$this->params['breadcrumbs'][] = $this->title;
?>
<div class="admin-create-course">
    <div class="row justify-content-center">
        <div class="col-lg-8">
            <div class="card">
                <div class="card-header">
                    <h1 class="card-title"><?= Html::encode($this->title) ?></h1>
                </div>
                <div class="card-body">
                    <?php $form = ActiveForm::begin([
                        'id' => 'course-form',
                        'options' => ['class' => 'form-horizontal'],
                        'fieldConfig' => [
                            'template' => "{label}\n<div class=\"col-lg-12\">{input}</div>\n<div class=\"col-lg-12\">{error}</div>",
                            'labelOptions' => ['class' => 'control-label'],
                        ],
                    ]); ?>

                    <div class="row">
                        <div class="col-md-12">
                            <?= $form->field($model, 'name')->textInput(['maxlength' => true, 'autofocus' => true])
                                ->hint('Введите название курса') ?>
                        </div>
                    </div>

                    <div class="row">
                        <div class="col-md-12">
                            <?= $form->field($model, 'description')->textarea(['rows' => 6])
                                ->hint('Подробное описание курса') ?>
                        </div>
                    </div>

                    <div class="row">
                        <div class="col-md-6">
                            <?= $form->field($model, 'duration_hours')->textInput(['type' => 'number', 'min' => 1])
                                ->hint('Продолжительность курса в часах') ?>
                        </div>
                        <div class="col-md-6">
                            <?= $form->field($model, 'price')->textInput(['type' => 'number', 'step' => '0.01', 'min' => 0])
                                ->hint('Стоимость курса в рублях') ?>
                        </div>
                    </div>

                    <div class="row">
                        <div class="col-md-12">
                            <?= $form->field($model, 'is_active')->checkbox([
                                'template' => "<div class=\"checkbox\">\n{beginLabel}\n{input}\n{labelTitle}\n{endLabel}\n{error}\n{hint}\n</div>",
                            ])->hint('Отметьте, если курс активен и доступен для выбора') ?>
                        </div>
                    </div>

                    <div class="form-group">
                        <div class="col-lg-12">
                            <?= Html::submitButton('<i class="glyphicon glyphicon-ok"></i> Создать курс', ['class' => 'btn btn-success btn-lg btn-block']) ?>
                            <?= Html::a('<i class="glyphicon glyphicon-remove"></i> Отмена', ['courses'], ['class' => 'btn btn-default btn-block mt-2']) ?>
                        </div>
                    </div>

                    <?php ActiveForm::end(); ?>
                </div>
            </div>
        </div>
    </div>
</div>