<?php

use yii\helpers\Html;
use yii\grid\GridView;
use yii\widgets\Pjax;

$this->title = 'Управление заявками';
$this->params['breadcrumbs'][] = $this->title;
?>
<div class="admin-applications">
    <div class="d-flex justify-content-between align-items-center mb-4">
        <h1><?= Html::encode($this->title) ?></h1>
        <div class="btn-group">
            <?= Html::a('<i class="glyphicon glyphicon-filter"></i> Фильтры', ['#'], [
                'class' => 'btn btn-default',
                'data-toggle' => 'collapse',
                'data-target' => '#filters',
                'aria-expanded' => 'false',
                'aria-controls' => 'filters'
            ]) ?>
            <?= Html::a('<i class="glyphicon glyphicon-refresh"></i> Обновить', ['applications'], ['class' => 'btn btn-default']) ?>
        </div>
    </div>

    <div class="collapse" id="filters">
        <div class="well">
            <h4>Фильтры заявок</h4>
            <form method="get" class="form-horizontal">
                <div class="row">
                    <div class="col-md-4">
                        <div class="form-group">
                            <label class="control-label col-md-4">Статус:</label>
                            <div class="col-md-8">
                                <select name="ApplicationSearch[status]" class="form-control">
                                    <option value="">Все статусы</option>
                                    <?php foreach (\app\models\Application::getStatusLabels() as $value => $label): ?>
                                        <option value="<?= $value ?>" <?= isset($searchModel->status) && $searchModel->status == $value ? 'selected' : '' ?>>
                                            <?= $label ?>
                                        </option>
                                    <?php endforeach; ?>
                                </select>
                            </div>
                        </div>
                    </div>
                    <div class="col-md-4">
                        <div class="form-group">
                            <label class="control-label col-md-4">Пользователь:</label>
                            <div class="col-md-8">
                                <?= Html::dropDownList(
                                    'ApplicationSearch[user_id]', 
                                    isset($searchModel->user_id) ? $searchModel->user_id : '', 
                                    \yii\helpers\ArrayHelper::map(\app\models\User::find()->all(), 'id', 'full_name'),
                                    ['class' => 'form-control', 'prompt' => 'Все пользователи']
                                ) ?>
                            </div>
                        </div>
                    </div>
                    <div class="col-md-4">
                        <div class="form-group">
                            <label class="control-label col-md-4">Курс:</label>
                            <div class="col-md-8">
                                <?= Html::dropDownList(
                                    'ApplicationSearch[course_id]', 
                                    isset($searchModel->course_id) ? $searchModel->course_id : '', 
                                    \yii\helpers\ArrayHelper::map(\app\models\Course::find()->all(), 'id', 'name'),
                                    ['class' => 'form-control', 'prompt' => 'Все курсы']
                                ) ?>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="row">
                    <div class="col-md-12 text-right">
                        <?= Html::submitButton('<i class="glyphicon glyphicon-filter"></i> Применить фильтры', ['class' => 'btn btn-primary']) ?>
                        <?= Html::a('<i class="glyphicon glyphicon-remove"></i> Сбросить', ['applications'], ['class' => 'btn btn-default']) ?>
                    </div>
                </div>
            </form>
        </div>
    </div>

    <?php Pjax::begin(); ?>
    <?= GridView::widget([
        'dataProvider' => $dataProvider,
        'filterModel' => $searchModel,
        'columns' => [
            ['class' => 'yii\grid\SerialColumn'],
            'id',
            [
                'attribute' => 'user_id',
                'value' => function($model) {
                    return $model->user ? $model->user->full_name : 'Не указан';
                },
                'filter' => \yii\helpers\ArrayHelper::map(\app\models\User::find()->all(), 'id', 'full_name'),
            ],
            [
                'attribute' => 'course_name',
                'value' => function($model) {
                    return $model->course_name;
                },
            ],
            [
                'attribute' => 'desired_start_date',
                'format' => 'date',
            ],
            [
                'attribute' => 'payment_method',
                'value' => function($model) {
                    return $model->paymentMethodLabel;
                },
                'filter' => \app\models\Application::getPaymentMethodLabels(),
            ],
            [
                'attribute' => 'status',
                'value' => function($model) {
                    return $model->statusLabel;
                },
                'content' => function($model) {
                    return '<span class="label label-' . $model->statusColor . '">' . $model->statusLabel . '</span>';
                },
                'format' => 'raw',
                'filter' => \app\models\Application::getStatusLabels(),
            ],
            [
                'attribute' => 'created_at',
                'format' => 'datetime',
            ],
            [
                'class' => 'yii\grid\ActionColumn',
                'template' => '{view} {status}',
                'buttons' => [
                    'view' => function ($url, $model, $key) {
                        return Html::a('<i class="glyphicon glyphicon-eye-open"></i>', 
                            ['view-application', 'id' => $model->id], 
                            ['title' => 'Просмотр', 'class' => 'btn btn-xs btn-info']);
                    },
                    'status' => function ($url, $model, $key) {
                        return Html::a('<i class="glyphicon glyphicon-edit"></i>', 
                            ['update-status', 'id' => $model->id], 
                            ['title' => 'Изменить статус', 'class' => 'btn btn-xs btn-warning']);
                    },
                ],
            ],
        ],
        'tableOptions' => ['class' => 'table table-striped table-bordered'],
        'pager' => [
            'options' => ['class' => 'pagination'],
            'prevPageLabel' => '<i class="glyphicon glyphicon-chevron-left"></i>',
            'nextPageLabel' => '<i class="glyphicon glyphicon-chevron-right"></i>',
        ],
    ]); ?>
    <?php Pjax::end(); ?>

    <div class="row mt-4">
        <div class="col-md-12">
            <div class="panel panel-default">
                <div class="panel-heading">
                    <h3 class="panel-title">Действия с заявками</h3>
                </div>
                <div class="panel-body">
                    <div class="btn-group">
                        <?= Html::a('<i class="glyphicon glyphicon-download"></i> Экспорт в Excel', ['export-applications'], [
                            'class' => 'btn btn-success',
                            'data' => ['confirm' => 'Экспортировать все заявки в Excel?']
                        ]) ?>
                        <?= Html::a('<i class="glyphicon glyphicon-print"></i> Печать', ['#'], [
                            'class' => 'btn btn-default',
                            'onclick' => 'window.print(); return false;'
                        ]) ?>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<style>
.label-new { background-color: #337ab7; }
.label-in_progress { background-color: #f0ad4e; }
.label-completed { background-color: #5cb85c; }
.label-rejected { background-color: #d9534f; }
</style>