<?php

use yii\helpers\Html;
use yii\helpers\Url;
use app\assets\AppAsset;

AppAsset::register($this);
?>
<?php $this->beginPage() ?>
<!DOCTYPE html>
<html lang="<?= Yii::$app->language ?>">
<head>
    <meta charset="<?= Yii::$app->charset ?>">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <?= Html::csrfMetaTags() ?>
    <title><?= Html::encode($this->title) ?> | Корочки.есть</title>
    <?php $this->head() ?>
    
    <!-- Bootstrap CSS -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.1.3/dist/css/bootstrap.min.css" rel="stylesheet">
    
    <!-- Подключаем Inputmask -->
    <script src="https://cdnjs.cloudflare.com/ajax/libs/jquery.inputmask/5.0.6/jquery.inputmask.min.js"></script>
    
    <style>
    body {
        padding-top: 70px;
    }
    .navbar-brand {
        font-weight: bold;
    }
    .footer {
        background-color: #f5f5f5;
        padding: 20px 0;
        margin-top: 40px;
        border-top: 1px solid #e5e5e5;
    }
    .logout-btn {
        border: none;
        background: none;
        color: rgba(255,255,255,.5);
        padding: 15px;
        cursor: pointer;
    }
    .logout-btn:hover {
        color: rgba(255,255,255,.75);
    }
    </style>
</head>
<body>
<?php $this->beginBody() ?>

<div class="wrap">
    <!-- Навигационное меню -->
    <nav class="navbar navbar-expand-lg navbar-dark bg-dark fixed-top">
        <div class="container">
            <a class="navbar-brand" href="<?= Url::to(['/site/index']) ?>">Корочки.есть</a>
            <button class="navbar-toggler" type="button" data-bs-toggle="collapse" data-bs-target="#navbarNav">
                <span class="navbar-toggler-icon"></span>
            </button>
            
            <div class="collapse navbar-collapse" id="navbarNav">
                <ul class="navbar-nav ms-auto">
                    <?php if (Yii::$app->user->isGuest): ?>
                        <li class="nav-item">
                            <a class="nav-link" href="<?= Url::to(['/site/login']) ?>">Вход</a>
                        </li>
                        <li class="nav-item">
                            <a class="nav-link" href="<?= Url::to(['/site/register']) ?>">Регистрация</a>
                        </li>
                    <?php else: ?>
                        <?php if (!Yii::$app->user->identity->isAdmin()): ?>
                            <li class="nav-item">
                                <a class="nav-link" href="<?= Url::to(['/application']) ?>">Мои заявки</a>
                            </li>
                            <li class="nav-item">
                                <a class="nav-link" href="<?= Url::to(['/application/create']) ?>">Подать заявку</a>
                            </li>
                        <?php endif; ?>
                        
                        <?php if (Yii::$app->user->identity->isAdmin()): ?>
                            <li class="nav-item">
                                <a class="nav-link" href="<?= Url::to(['/admin']) ?>">Панель администратора</a>
                            </li>
                        <?php endif; ?>
                        
                        <li class="nav-item">
                            <form action="<?= Url::to(['/site/logout']) ?>" method="post">
                                <input type="hidden" name="<?= Yii::$app->request->csrfParam ?>" value="<?= Yii::$app->request->csrfToken ?>">
                                <button type="submit" class="logout-btn">
                                    Выйти (<?= Html::encode(Yii::$app->user->identity->username) ?>)
                                </button>
                            </form>
                        </li>
                    <?php endif; ?>
                </ul>
            </div>
        </div>
    </nav>

    <div class="container">
        <!-- Хлебные крошки -->
        <?php if (isset($this->params['breadcrumbs'])): ?>
            <nav aria-label="breadcrumb" class="mt-3">
                <ol class="breadcrumb">
                    <li class="breadcrumb-item"><a href="<?= Url::to(['/site/index']) ?>">Главная</a></li>
                    <?php foreach ($this->params['breadcrumbs'] as $crumb): ?>
                        <?php if (is_array($crumb) && isset($crumb['label'])): ?>
                            <li class="breadcrumb-item">
                                <a href="<?= Url::to($crumb['url']) ?>"><?= Html::encode($crumb['label']) ?></a>
                            </li>
                        <?php else: ?>
                            <li class="breadcrumb-item active" aria-current="page">
                                <?= Html::encode($crumb) ?>
                            </li>
                        <?php endif; ?>
                    <?php endforeach; ?>
                </ol>
            </nav>
        <?php endif; ?>
        
        <!-- Отображение flash-сообщений -->
        <?php if (Yii::$app->session->hasFlash('success')): ?>
            <div class="alert alert-success alert-dismissible fade show mt-3" role="alert">
                <?= Yii::$app->session->getFlash('success') ?>
                <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
            </div>
        <?php endif; ?>
        
        <?php if (Yii::$app->session->hasFlash('error')): ?>
            <div class="alert alert-danger alert-dismissible fade show mt-3" role="alert">
                <?= Yii::$app->session->getFlash('error') ?>
                <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
            </div>
        <?php endif; ?>
        
        <!-- Основное содержимое -->
        <?= $content ?>
    </div>
</div>

<footer class="footer">
    <div class="container">
        <div class="row">
            <div class="col-md-6">
                <p class="text-muted">&copy; Портал "Корочки.есть" <?= date('Y') ?></p>
            </div>
            <div class="col-md-6 text-end">
                <p class="text-muted">Система записи на онлайн курсы дополнительного образования</p>
            </div>
        </div>
    </div>
</footer>

<!-- Bootstrap JS -->
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.1.3/dist/js/bootstrap.bundle.min.js"></script>
<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>

<script>
$(document).ready(function() {
    // Инициализация масок
    if (typeof $.fn.inputmask !== 'undefined') {
        $('input[data-mask]').each(function() {
            $(this).inputmask($(this).data('mask'));
        });
    }
    
    // Маска для телефона
    $('#user-phone').inputmask('8(999)999-99-99');
    
    // Автоматическое скрытие alert через 5 секунд
    setTimeout(function() {
        $('.alert').alert('close');
    }, 5000);
});
</script>

<?php $this->endBody() ?>
</body>
</html>
<?php $this->endPage() ?>