<?php

use yii\db\Migration;

/**
 * Handles the creation of table `{{%applications}}`.
 */
class m251221_094105_create_applications_table extends Migration
{
    /**
     * {@inheritdoc}
     */
    public function safeUp()
    {
        $this->createTable('{{%applications}}', [
            'id' => $this->primaryKey(),
            'user_id' => $this->integer()->notNull(),
            'course_id' => $this->integer()->notNull(),
            'course_name' => $this->string(200)->notNull(),
            'desired_start_date' => $this->date()->notNull(),
            'payment_method' => $this->string(20)->notNull(),
            'status' => $this->string(20)->defaultValue('new'),
            'feedback' => $this->text(),
            'rating' => $this->integer(),
            'created_at' => $this->timestamp()->defaultExpression('CURRENT_TIMESTAMP'),
            'updated_at' => $this->timestamp()->defaultExpression('CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP'),
        ]);

         $this->addForeignKey(
            'fk_applications_user_id',
            '{{%applications}}',
            'user_id',
            '{{%users}}',
            'id',
            'CASCADE',
            'CASCADE'
        );

        $this->addForeignKey(
            'fk_applications_course_id',
            '{{%applications}}',
            'course_id',
            '{{%courses}}',
            'id',
            'CASCADE',
            'CASCADE'
        );

        $this->createIndex(
            'idx_applications_status',
            '{{%applications}}',
            'status'
        );

        $this->createIndex(
            'idx_applications_user_id',
            '{{%applications}}',
            'user_id'
        );

        // Добавляем тестовые заявки
        $this->insert('{{%applications}}', [
            'user_id' => 2, // testuser
            'course_id' => 1,
            'course_name' => 'Веб-разработка на PHP и Yii2',
            'desired_start_date' => date('Y-m-d', strtotime('+1 month')),
            'payment_method' => 'cash',
            'status' => 'new',
            'created_at' => date('Y-m-d H:i:s'),
        ]);

        $this->insert('{{%applications}}', [
            'user_id' => 2,
            'course_id' => 2,
            'course_name' => 'JavaScript продвинутый уровень',
            'desired_start_date' => date('Y-m-d', strtotime('+2 weeks')),
            'payment_method' => 'transfer',
            'status' => 'in_progress',
            'created_at' => date('Y-m-d H:i:s', strtotime('-1 week')),
        ]);

        $this->insert('{{%applications}}', [
            'user_id' => 2,
            'course_id' => 3,
            'course_name' => 'Дизайн интерфейсов UX/UI',
            'desired_start_date' => date('Y-m-d', strtotime('-1 month')),
            'payment_method' => 'cash',
            'status' => 'completed',
            'feedback' => 'Отличный курс! Преподаватель очень понятно объясняет материал.',
            'rating' => 5,
            'created_at' => date('Y-m-d H:i:s', strtotime('-2 months')),
        ]);
        
    }

    /**
     * {@inheritdoc}
     */
    public function safeDown()
    {
        $this->dropTable('{{%applications}}');
    }
}
