<?php

use yii\db\Migration;

/**
 * Handles the creation of table `{{%users}}`.
 */
class m251221_093920_create_users_table extends Migration
{
    /**
     * {@inheritdoc}
     */
    public function safeUp()
    {
        $this->createTable('{{%users}}', [
            'id' => $this->primaryKey(),
            'username' => $this->string(50)->notNull()->unique(),
            'password_hash' => $this->string(255)->notNull(),
            'auth_key' => $this->string(32),
            'access_token' => $this->string(255),
            'full_name' => $this->string(100)->notNull(),
            'phone' => $this->string(20)->notNull(),
            'email' => $this->string(100)->notNull()->unique(),
            'role' => $this->string(20)->defaultValue('user'),
            'created_at' => $this->timestamp()->defaultExpression('CURRENT_TIMESTAMP'),
            'updated_at' => $this->timestamp()->defaultExpression('CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP'),
        ]);

         $this->insert('{{%users}}', [
            'username' => 'Admin',
            'password_hash' => Yii::$app->security->generatePasswordHash('KorokNET'),
            'auth_key' => Yii::$app->security->generateRandomString(),
            'full_name' => 'Администратор Системы',
            'phone' => '8(999)999-99-99',
            'email' => 'admin@korokki-est.ru',
            'role' => 'admin',
        ]);

        $this->insert('{{%users}}', [
            'username' => 'testuser',
            'password_hash' => Yii::$app->security->generatePasswordHash('password123'),
            'auth_key' => Yii::$app->security->generateRandomString(),
            'full_name' => 'Тестовый Пользователь',
            'phone' => '8(123)456-78-90',
            'email' => 'test@example.com',
            'role' => 'user',
        ]);
    }

    /**
     * {@inheritdoc}
     */
    public function safeDown()
    {
        $this->dropTable('{{%users}}');
    }
}
