<?php

namespace app\controllers;

use Yii;
use yii\web\Controller;
use yii\web\Response;
use yii\widgets\ActiveForm;
use app\models\User;
use app\models\LoginForm;
use app\models\Course;

class SiteController extends Controller
{
    /**
     * {@inheritdoc}
     */
    public function actions()
    {
        return [
            'error' => [
                'class' => 'yii\web\ErrorAction',
            ],
        ];
    }

    /**
     * Главная страница
     */
    public function actionIndex()
    {
        return $this->render('index');
    }

    /**
     * Регистрация
     */
    public function actionRegister()
    {
        if (!Yii::$app->user->isGuest) {
            return $this->goHome();
        }

        $model = new User();
        $model->scenario = 'register';

        if (Yii::$app->request->isPost) {
            $model->load(Yii::$app->request->post());
            
            if (Yii::$app->request->isAjax) {
                Yii::$app->response->format = Response::FORMAT_JSON;
                return ActiveForm::validate($model);
            }
            
            if ($model->validate()) {
                $model->setPassword($model->password);
                
                if ($model->save()) {
                    Yii::$app->session->setFlash('success', 'Регистрация успешно завершена. Теперь вы можете войти в систему.');
                    return $this->redirect(['site/login']);
                } else {
                    Yii::$app->session->setFlash('error', 'Произошла ошибка при сохранении пользователя.');
                }
            }
        }

        return $this->render('register', [
            'model' => $model,
        ]);
    }

    /**
     * Авторизация
     */
    public function actionLogin()
    {
        if (!Yii::$app->user->isGuest) {
            return $this->goHome();
        }

        $model = new LoginForm();
        
        if ($model->load(Yii::$app->request->post())) {
            if ($model->login()) {
                Yii::$app->session->setFlash('success', 'Вы успешно авторизовались!');
                return $this->goBack();
            } else {
                Yii::$app->session->setFlash('error', 'Неправильный логин или пароль.');
            }
        }

        $model->password = '';
        
        return $this->render('login', [
            'model' => $model,
        ]);
    }

    /**
     * Выход
     */
    public function actionLogout()
    {
        Yii::$app->user->logout();
        return $this->goHome();
    }

    /**
     * Страница с курсами
     */
    public function actionCourses()
    {
        $courses = Course::find()->where(['is_active' => true])->all();
        
        return $this->render('courses', [
            'courses' => $courses,
        ]);
    }
}